module net.BurtonRadons.dedit.options;

import net.BurtonRadons.dedit.main;
import net.BurtonRadons.dig.main;
import std.utf;

class ColorBox : Canvas
{
    Color *output;
    View view;

    this (Control parent, Color *output, View view)
    {
        super (parent);
        onLButtonUp.add (&doSelect);
        onPaint.add (&doPaint);
        width (16);
        height (16);
        pad (0, 0);

        this.output = output;
        this.view = view;
    }

    void doPaint (Event e)
    {
        beginPaint ();
        clear (*output);
        endPaint ();
    }

    void doSelect (Event e)
    {
        with (global.colorSelector)
        {
            color = *output;
            if (run ())
            {
                *output = color;
                paint ();
                view.paint ();
                global.projectView.paint ();
            }
        }
    }
}

class TabSelect
{
    OptionsFrame frame;
    SyntaxHighlighter type;

    this (OptionsFrame frame, SyntaxHighlighter type)
    {
        this.frame = frame;
        this.type = type;
    }

    void doChange (Event e)
    {
        TabParams p, def;

        if (type !== null)
            def = type.tabParamsDefault ();
        for (int c; c < global.tabParams.length; c ++)
        {
            if (global.tabParams [c].type === null && def === null)
                def = global.tabParams [c];
            if (global.tabParams [c].type === type)
            {
                p = global.tabParams [c];
                break;
            }
        }

        if (p === null)
        {
            p = new TabParams ();
            global.tabParams ~= p;
            p.type = type;
            
            if (def !== null)
            {
                p.tabSize = def.tabSize;
                p.indentSize = def.indentSize;
                p.keepTabs = def.keepTabs;
                p.useDefault = def.useDefault;
            }
        }        

        frame.tabParams = p;
        frame.tabTabSize.value (p.tabSize);
        frame.tabIndentSize.value (p.indentSize);
        frame.tabGroup.value ((int) p.keepTabs);
        frame.tabUseDefault.enabled (p.type !== null);

        bit d = p.useDefault && (p.type !== null);

        frame.tabUseDefault.checked (d);

        frame.tabTabSize.enabled (!d);
        frame.tabIndentSize.enabled (!d);
        frame.tabInsertSpacesButton.enabled (!d);
        frame.tabKeepTabsButton.enabled (!d);
    }
}

class OptionsFrame : Frame
{
    RadioGroup tabGroup;
    TabParams tabParams;
    Spinner tabTabSize;
    Spinner tabIndentSize;
    CheckBox tabUseDefault;
    RadioButton tabInsertSpacesButton;
    RadioButton tabKeepTabsButton;

    void tabInsertSpaces () { tabParams.keepTabs = false; }
    void tabKeepTabs () { tabParams.keepTabs = true; }
    void tabUseDefaultClick ()
    {
        TabParams p = tabParams;

        tabUseDefault.checked (p.useDefault = !p.useDefault);

        tabTabSize.enabled (!p.useDefault);
        tabIndentSize.enabled (!p.useDefault);
        tabInsertSpacesButton.enabled (!p.useDefault);
        tabKeepTabsButton.enabled (!p.useDefault);
    }

    void doTabIndentSize (float value) { tabParams.indentSize = value; }
    void doTabTabSize (float value) { tabParams.tabSize = value; }

    void setupTabs (int col, int row)
    {
        GroupBox box;
        ComboBox com;
        int r = 0;

        with (box = new GroupBox (this))
        {
            grid (2, 0);
            sticky ("^v");
            caption ("Tabs");
        }

        TabSelect tabDefault;

        with (com = new ComboBox (box))
        {
            gridAddRow (0, r, 3, 1);
            sticky ("<>");

            SyntaxHighlighter [] list = SyntaxHighlighter.list.sort;

            tabDefault = new TabSelect (this, null);
            add ("Default", "Default", &tabDefault.doChange);

            for (int c; c < list.length; c ++)
                add (list [c].name (), list [c].name (), &(new TabSelect (this, list [c])).doChange);
        }

        with (new Label (box))
            grid (0, r), caption ("&Tab size:");
        with (tabTabSize = new Spinner (box))
        {
            gridAddRow (1, r);
            range (1, 100, 1);
            onChange.add (&doTabTabSize);
        }

        with (new Label (box))
            grid (0, r), caption ("&Indent size:");
        with (tabIndentSize = new Spinner (box))
        {
            gridAddRow (1, r);
            range (1, 100, 1);
            onChange.add (&doTabIndentSize);
        }

        RadioButton radio;

        tabGroup = new RadioGroup ();

        with (tabInsertSpacesButton = radio = new RadioButton (box))
        {
            gridAddRow (0, r, 2, 1);
            caption ("Insert &spaces");
            tabGroup.add (radio, 0, &tabInsertSpaces);
        }

        with (tabKeepTabsButton = radio = new RadioButton (box))
        {
            gridAddRow (0, r, 2, 1);
            caption ("&Keep tabs");
            tabGroup.add (radio, 1, &tabKeepTabs);
        }

        with (tabUseDefault = new CheckBox (box))
        {
            gridAddRow (0, r, 2, 1);
            caption ("&Use default");
            onClick.add (&tabUseDefaultClick);
        }

        Event e;
        tabDefault.doChange (e);
        com.current ("Default");
    }
}

/* Provides options dialogs. */
class OptionsCommand
{
    this ()
    {
        alias View.addCommand e;

        e ("Options", ".", &Options, "Show the options dialog.",
            "Show the options dialog.");
        e ("KeyboardMap", ".", &KeyboardMap,
            "Shows a keyboard map window.",
            "Displays a window showing the current keyboard bindings.  This is not the same "
            "as the CommandBindings command, in that the bindings cannot be modified.");
    }

    static this ()
    {
        new OptionsCommand ();
    }

    void addBindings (View view, ListBox box, View.charArray [char []] blist, char [] prefix)
    {
        char [] [] keys = blist.keys;

        for (int c; c < keys.length; c ++)
            box.addText (prefix ~ keys [c], View.commandDescs [blist [keys [c]]]);
    }

    /* Display a keyboard map window. */
    void KeyboardMap (View view)
    {
        ListBox box;
        Frame frame;

        with (frame = new Frame ())
        {
            caption ("Keyboard Map");
            border (0, 0);
        }

        with (box = new ListBox (frame))
        {
            grid (0, 0);
            addColumn ("Code", 100);
            addColumn ("Description", 300);
            suggestHeight (400);
            sticky ("<>^v");
        }

        addBindings (view, box, view.bindings, "");
        addBindings (view, box, view.shiftBindings, "Shift+");
        addBindings (view, box, view.controlBindings, "Control+");
        addBindings (view, box, view.shiftControlBindings, "Shift+Control+");

        frame.display ();
    }

    OptionsFrame frame;
    View view;

    void addColor (char [] name, Color *color, Control con, View view, int c, inout int r)
    {
        with (new ColorBox (con, color, view))
            grid (c, r);
        Label label;
        with (label = new Label (con))
        {
            caption (name);
            grid (c + 1, r);
            pad (3, 0);
        }
        r += 1;
    }

    void Options (View view)
    {
        GroupBox box;
        Pane pane;
        int r;

        this.view = view;
        with (frame = new OptionsFrame ())
        {
            caption ("Dedit Options");
            maximizable (false);
            resizable (false);
        }

        with (box = new GroupBox (frame))
        {
            caption ("Editor");
            grid (0, 0);
            sticky ("v^");
        }

        addColor ("Background", &global.background, box, view, 0, r);
        addColor ("Comments", &global.colorComment, box, view, 0, r);
        addColor ("Cursor", &global.colorCursor, box, view, 0, r);
        addColor ("Identifiers", &global.colorIdentifier, box, view, 0, r);
        addColor ("Keywords", &global.colorKeyword, box, view, 0, r);
        addColor ("Numbers", &global.colorNumber, box, view, 0, r);
        addColor ("Selection", &global.colorSelection, box, view, 0, r);
        addColor ("Special Identifiers", &global.colorSpecialIdentifier, box, view, 0, r);
        addColor ("Strings", &global.colorString, box, view, 0, r);
        addColor ("Symbols", &global.colorSymbol, box, view, 0, r);
        addColor ("Text", &global.colorText, box, view, 0, r);
        
        with (new Button (box))
        {
            gridAddRow (0, r, 2, 1);
            sticky ("<>");
            caption ("Text Font");
            onClick.add (&textFont);
            pad (0, 0);
        }

        r = 0;

        frame.setupTabs (1, 0);

        with (pane = new Pane (frame))
        {
            grid (0, 1, 3, 1);
            sticky (">");
        }

        with (new Button (pane))
        {
            width (100);
            grid (0, 0);
            sticky ("<>");
            caption ("&Okay");
            onClick.add (&okay);
            bordered (true);
            bind ("Return", &onClick);
        }

        with (new Button (pane))
        {
            width (100);
            grid (1, 0);
            sticky ("<>");
            caption ("&Cancel");
            onClick.add (&cancel);
            bind ("Escape", &onClick);
        }

        frame.display ();
    }

    void textFont (Event e)
    {
        Font f;

        with (new FontSelector (global.font))
        {
            effects = false;
            if ((f = run ()) !== null)
            {
                global.font = f;
                global.fontHeight = f.height (view);
                view.paint ();
            }
        }
    }

    void projectTextFont (Event e)
    {
        Font f;

        with (new FontSelector (global.projectFont))
        {
            effects = false;
            if ((f = run ()) !== null)
            {
                global.projectFont = f;
                global.projectFontHeight = f.height (view);
                global.projectView.paint ();
            }
        }
    }

    void okay (Event e)
    {
        global.save ();
        view.paint ();
        delete frame;
    }

    void cancel (Event e)
    {
        global.load ();
        view.paint ();
        delete frame;
    }
}
